# validate_crossover_alignment.py
import os, re, glob, numpy as np, yaml, pandas as pd

CFG = yaml.safe_load(open("configs/default.yaml","r",encoding="utf-8"))
adj = pd.read_csv("data/results/vol4_wilson_loop_adjoint_volume_sweep/adjoint_volume_summary.csv")

def get(cfg, *cands, required=True, default=None):
    for path in cands:
        node = cfg
        ok = True
        for k in path.split("."):
            if isinstance(node, dict) and k in node:
                node = node[k]
            else:
                ok = False; break
        if ok: return node
    if required: raise KeyError(f"None of {cands} found in config")
    return default

Ls = sorted(adj["L"].unique().tolist())
kpaths = get(CFG, "adjoint_volume.kernel_paths")

def find_rho(L:int):
    # try config templates first (add your own if you have them)
    templates = [
        f"data/results/vol4_wilson_loop_pipeline_crossover_analysis/rho_grid_L{L}.npy",
        f"data/artifacts/rho_grid_L{L}.npy",
        f"artifacts/rho_grid_L{L}.npy",
        f"data/**/rho_grid_L{L}.npy",
        f"**/rho_grid_L{L}.npy",
    ]
    for t in templates:
        for p in glob.glob(t, recursive=True):
            if os.path.exists(p): return p
    return None

def main():
    ok = True
    for L in Ls:
        # load any kernel to get expected size
        kp = kpaths["SU2"].format(L=int(L))
        k = np.load(kp)
        exp = 2*L*L
        if k.size != exp:
            print(f"[FAIL] kernel {kp} size={k.size} != 2*L^2={exp}")
            ok = False

        rp = find_rho(int(L))
        if not rp:
            print(f"[WARN] no rho_grid found for L={L} (searched common locations)")
            continue
        rho = np.load(rp)
        if rho.size != exp:
            print(f"[FAIL] rho_grid {rp} size={rho.size} != 2*L^2={exp}")
            ok = False
        else:
            print(f"[OK] L={L}: rho_grid matches 2*L^2 ({exp}); file: {rp}")

    raise SystemExit(0 if ok else 2)

if __name__ == "__main__":
    main()
